/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.schedops.beans;

import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class RepeatBean
extends PanelBean {
    private static final String CLASS_NAME = "[RepeatBean] ";
    private static final String TRACE_MASKT = "XTIMxxxT";
    private static final String TRACE_MASKF = "XTIMxxxF";
    private static final String TRACE_MASKD = "XTIMxxxD";
    private static final long INDEFINITE = -1L;
    private static final String CANCEL = "CANCEL";
    private static final String FRI_TOGGLE = "FridayToggle";
    private static final String HOURS_EDIT = "HoursEdit";
    private static final String INFREP_TOGGLE = "RepToggle";
    private static final String INTERVAL_EDIT = "IntervalEdit";
    private static final String MINUTES_EDIT = "MinutesEdit";
    private static final String MON_TOGGLE = "MondayToggle";
    private static final String REPEAT_TOGGLE = "RepeatItem";
    private static final String REPS_EDIT = "RepetitionsEdit";
    private static final String SAT_TOGGLE = "SaturdayToggle";
    private static final String SINGLE_TOGGLE = "SingleItem";
    private static final String SUN_TOGGLE = "SundayToggle";
    private static final String THU_TOGGLE = "ThursdayToggle";
    private static final String TUE_TOGGLE = "TuesdayToggle";
    private static final String WED_TOGGLE = "WednesdayToggle";
    private String m_sSelectListOutput;
    private String[] m_sSingleRepeatChoiceSelection;
    private boolean m_bMondayToggle;
    private boolean m_bFridayToggle;
    private boolean m_bTuesdayToggle;
    private boolean m_bSaturdayToggle;
    private boolean m_bWednesdayToggle;
    private boolean m_bSundayToggle;
    private boolean m_bThursdayToggle;
    private String m_sIntervalWeeksOutput;
    private int m_dIntervalEdit;
    private int m_dHoursEdit;
    private int m_dMinutesEdit;
    private int m_dRepetitionsEdit;
    private boolean m_bRepToggle;
    private ArrayList objectNames;
    private boolean priviledgedUser;

    public RepeatBean(String name, ArrayList objectNames, boolean priviledged) {
        Trace.trace(TRACE_MASKT, "[RepeatBean] <> RepeatBean() : " + priviledged);
        this.setBeanName(name);
        this.objectNames = objectNames;
        this.priviledgedUser = priviledged;
    }

    public void prepare() {
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = this.objectNames.iterator();
        while (iterator.hasNext()) {
            buffer.append(((LocalizableText)iterator.next()).toString());
            buffer.append("  ");
        }
        this.setSelectListOutput(buffer.toString());
        this.getUserTaskManager().setSelected(this.getMountPrefix() + SINGLE_TOGGLE, true);
        this.setEnabledStates();
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "[RepeatBean] >> panelAction() : \n\tBean Name     : " + this.getBeanName() + "\n\tCurrentElement: " + event.getCurrentElement() + "\n\tElementName   : " + event.getElementName() + "\n\tActionCommand : " + event.getActionCommand());
        String elementName = event.getElementName();
        String actionCommand = event.getActionCommand();
        if (actionCommand.endsWith(CANCEL)) {
            this.sendTaskletRequest(actionCommand, null);
        }
        Trace.trace(TRACE_MASKT, "<< panelAction()");
    }

    public void parentalAction(TaskActionEvent event, PanelBean parent) {
        Trace.trace(TRACE_MASKT, "[RepeatBean] <> parentalAction() : \n\tBean Name     : " + this.getBeanName() + "\n\tCurrentElement: " + event.getCurrentElement() + "\n\tElementName   : " + event.getElementName() + "\n\tActionCommand : " + event.getActionCommand());
        boolean dataValid = true;
        try {
            this.userTaskManager.storeAllElements();
        }
        catch (Exception e) {
            dataValid = false;
        }
        Trace.trace(TRACE_MASKF, "[RepeatBean]  Panel data is valid : " + dataValid);
        if (dataValid) {
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            ArrayList<Integer> days = new ArrayList<Integer>();
            long weeks = (long)Math.round(this.getIntervalEdit()) * 604800000L;
            long hours = (long)Math.round(this.getHoursEdit()) * 3600000L;
            long minutes = (long)Math.round(this.getMinutesEdit()) * 60000L;
            Long interval = new Long(weeks + hours + minutes);
            Long repetitions = new Long(1L);
            if (this.userTaskManager.isSelected(this.getMountPrefix() + REPEAT_TOGGLE)) {
                if (this.isSundayToggle()) {
                    days.add(new Integer(1));
                }
                if (this.isMondayToggle()) {
                    days.add(new Integer(2));
                }
                if (this.isTuesdayToggle()) {
                    days.add(new Integer(3));
                }
                if (this.isWednesdayToggle()) {
                    days.add(new Integer(4));
                }
                if (this.isThursdayToggle()) {
                    days.add(new Integer(5));
                }
                if (this.isFridayToggle()) {
                    days.add(new Integer(6));
                }
                if (this.isSaturdayToggle()) {
                    days.add(new Integer(7));
                }
                repetitions = this.isRepToggle() ? new Long(-1L) : new Long(Math.round(this.getRepetitionsEdit()));
            }
            map.put("INTERVAL", interval);
            map.put("REPETITIONS", repetitions);
            map.put("DAYSOFWEEK", days);
            this.sendTaskletRequest("PANEL_DATA", map);
        } else {
            this.sendTaskletRequest("DATA_NOT_VALID", null);
        }
    }

    private void sendTaskletRequest(String actionCommand, Object data) {
        PanelTaskletRequest request = new PanelTaskletRequest(this.getBeanName() + '.' + actionCommand);
        request.setData("SOURCE", this.getBeanName());
        request.setData("ACTION", actionCommand);
        request.setData("DATA", data);
        this.postTaskletRequest(request);
    }

    private void setEnabledStates() {
        Trace.trace(TRACE_MASKT, "[RepeatBean] <> setEnabledStates() : " + this.priviledgedUser);
        UserTaskManager utm = this.getUserTaskManager();
        String mountPrefix = this.getMountPrefix();
        boolean single = utm.isSelected(mountPrefix + SINGLE_TOGGLE);
        boolean repeat = utm.isSelected(mountPrefix + REPEAT_TOGGLE);
        boolean infrep = utm.isSelected(mountPrefix + INFREP_TOGGLE);
        utm.setShown(mountPrefix + HOURS_EDIT, this.priviledgedUser);
        utm.setShown(mountPrefix + MINUTES_EDIT, this.priviledgedUser);
        utm.setEnabled(mountPrefix + MON_TOGGLE, repeat);
        utm.setEnabled(mountPrefix + TUE_TOGGLE, repeat);
        utm.setEnabled(mountPrefix + WED_TOGGLE, repeat);
        utm.setEnabled(mountPrefix + THU_TOGGLE, repeat);
        utm.setEnabled(mountPrefix + FRI_TOGGLE, repeat);
        utm.setEnabled(mountPrefix + SAT_TOGGLE, repeat);
        utm.setEnabled(mountPrefix + SUN_TOGGLE, repeat);
        utm.setEnabled(mountPrefix + INTERVAL_EDIT, repeat);
        utm.setEnabled(mountPrefix + HOURS_EDIT, repeat);
        utm.setEnabled(mountPrefix + MINUTES_EDIT, repeat);
        utm.setEnabled(mountPrefix + INFREP_TOGGLE, repeat);
        utm.setEnabled(mountPrefix + REPS_EDIT, repeat && !infrep);
    }

    public String getSelectListOutput() {
        return this.m_sSelectListOutput;
    }

    public void setSelectListOutput(String s) throws IllegalUserDataException {
        this.m_sSelectListOutput = s;
    }

    public String[] getSingleRepeatChoiceSelection() {
        return this.m_sSingleRepeatChoiceSelection;
    }

    public void setSingleRepeatChoiceSelection(String[] selected) throws IllegalUserDataException {
        this.m_sSingleRepeatChoiceSelection = selected;
        this.setEnabledStates();
    }

    public boolean isMondayToggle() {
        return this.m_bMondayToggle;
    }

    public void setMondayToggle(boolean b) throws IllegalUserDataException {
        this.m_bMondayToggle = b;
    }

    public boolean isFridayToggle() {
        return this.m_bFridayToggle;
    }

    public void setFridayToggle(boolean b) throws IllegalUserDataException {
        this.m_bFridayToggle = b;
    }

    public boolean isTuesdayToggle() {
        return this.m_bTuesdayToggle;
    }

    public void setTuesdayToggle(boolean b) throws IllegalUserDataException {
        this.m_bTuesdayToggle = b;
    }

    public boolean isSaturdayToggle() {
        return this.m_bSaturdayToggle;
    }

    public void setSaturdayToggle(boolean b) throws IllegalUserDataException {
        this.m_bSaturdayToggle = b;
    }

    public boolean isWednesdayToggle() {
        return this.m_bWednesdayToggle;
    }

    public void setWednesdayToggle(boolean b) throws IllegalUserDataException {
        this.m_bWednesdayToggle = b;
    }

    public boolean isSundayToggle() {
        return this.m_bSundayToggle;
    }

    public void setSundayToggle(boolean b) throws IllegalUserDataException {
        this.m_bSundayToggle = b;
    }

    public boolean isThursdayToggle() {
        return this.m_bThursdayToggle;
    }

    public void setThursdayToggle(boolean b) throws IllegalUserDataException {
        this.m_bThursdayToggle = b;
    }

    public int getIntervalEdit() {
        return this.m_dIntervalEdit;
    }

    public void setIntervalEdit(int d) throws IllegalUserDataException {
        this.m_dIntervalEdit = d;
    }

    public String getIntervalWeeksOutput() {
        return this.m_sIntervalWeeksOutput;
    }

    public void setIntervalWeeksOutput(String s) throws IllegalUserDataException {
        this.m_sIntervalWeeksOutput = s;
    }

    public int getHoursEdit() {
        return this.m_dHoursEdit;
    }

    public void setHoursEdit(int d) throws IllegalUserDataException {
        this.m_dHoursEdit = d;
    }

    public int getMinutesEdit() {
        return this.m_dMinutesEdit;
    }

    public void setMinutesEdit(int d) throws IllegalUserDataException {
        this.m_dMinutesEdit = d;
    }

    public int getRepetitionsEdit() {
        return this.m_dRepetitionsEdit;
    }

    public void setRepetitionsEdit(int d) throws IllegalUserDataException {
        this.m_dRepetitionsEdit = d;
    }

    public boolean isRepToggle() {
        return this.m_bRepToggle;
    }

    public void setRepToggle(boolean b) throws IllegalUserDataException {
        this.m_bRepToggle = b;
        this.setEnabledStates();
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "[RepeatBean] <> verifyChanges()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "[RepeatBean] <> save()");
    }

    public void load() {
        this.m_sSelectListOutput = "";
        this.m_sIntervalWeeksOutput = "";
        this.m_sSingleRepeatChoiceSelection = new String[1];
        this.m_sSingleRepeatChoiceSelection[0] = SINGLE_TOGGLE;
        this.m_bMondayToggle = false;
        this.m_bFridayToggle = false;
        this.m_bTuesdayToggle = false;
        this.m_bSaturdayToggle = false;
        this.m_bWednesdayToggle = false;
        this.m_bSundayToggle = false;
        this.m_bThursdayToggle = false;
        this.m_bRepToggle = false;
        this.m_dIntervalEdit = 1;
        this.m_dHoursEdit = 0;
        this.m_dMinutesEdit = 0;
        this.m_dRepetitionsEdit = 1;
    }
}

